/*
 * Decompiled with CFR 0.152.
 */
package carpettisaddition.logging.loggers.microtiming.events;

import carpet.utils.Messenger;
import carpettisaddition.logging.loggers.microtiming.MicroTimingLoggerManager;
import carpettisaddition.logging.loggers.microtiming.enums.EventType;
import carpettisaddition.logging.loggers.microtiming.events.BaseEvent;
import carpettisaddition.logging.loggers.microtiming.utils.MicroTimingUtil;
import carpettisaddition.utils.TextUtil;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Objects;
import net.minecraft.class_1953;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2554;

public class ScheduleTileTickEvent
extends BaseEvent {
    private final class_2248 block;
    private final class_2338 pos;
    private final int delay;
    private final class_1953 priority;
    private final Boolean success;

    public ScheduleTileTickEvent(class_2248 block, class_2338 pos, int delay, class_1953 priority, Boolean success) {
        super(EventType.EVENT, "schedule_tile_tick");
        this.block = block;
        this.pos = pos;
        this.delay = delay;
        this.priority = priority;
        this.success = success;
    }

    @Override
    public class_2554 toText() {
        ArrayList list = Lists.newArrayList();
        list.add(this.getEnclosedTranslatedBlockNameHeaderText(this.block));
        list.add("c " + this.tr("Scheduled"));
        list.add(TextUtil.getSpaceText());
        list.add("c " + this.tr("TileTick Event"));
        list.add(String.format("^w %s: %dgt\n%s: %d (%s)", MicroTimingLoggerManager.tr("Delay"), this.delay, MicroTimingLoggerManager.tr("Priority"), this.priority.method_8681(), this.priority));
        if (this.success != null) {
            list.add("w  ");
            list.add(MicroTimingUtil.getSuccessText(this.success, false));
        }
        return Messenger.c((Object[])list.toArray(new Object[0]));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ScheduleTileTickEvent)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ScheduleTileTickEvent that = (ScheduleTileTickEvent)o;
        return this.delay == that.delay && Objects.equals(this.block, that.block) && Objects.equals(this.pos, that.pos) && this.priority == that.priority && Objects.equals(this.success, that.success);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.block, this.pos, this.delay, this.priority);
    }
}

