/*
 * Decompiled with CFR 0.152.
 */
package carpettisaddition.logging.loggers.microtiming.message;

import carpet.utils.Messenger;
import carpettisaddition.logging.loggers.microtiming.MicroTimingLogger;
import carpettisaddition.logging.loggers.microtiming.MicroTimingLoggerManager;
import carpettisaddition.logging.loggers.microtiming.enums.EventType;
import carpettisaddition.logging.loggers.microtiming.enums.TickStage;
import carpettisaddition.logging.loggers.microtiming.events.BaseEvent;
import carpettisaddition.logging.loggers.microtiming.message.MessageType;
import carpettisaddition.logging.loggers.microtiming.tickstages.TickStageExtraBase;
import carpettisaddition.logging.loggers.microtiming.utils.MicroTimingUtil;
import carpettisaddition.utils.TextUtil;
import carpettisaddition.utils.stacktrace.StackTracePrinter;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_1767;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2554;
import net.minecraft.class_5321;

public class MicroTimingMessage {
    private static final int MAX_INDENT = 10;
    private static final int SPACE_PER_INDENT = 2;
    private static final List<String> INDENTATIONS = Lists.newArrayList();
    private final class_5321<class_1937> dimensionType;
    private final class_2338 pos;
    private final class_1767 color;
    private final TickStage stage;
    private final String stageDetail;
    private final TickStageExtraBase stageExtra;
    private final class_2554 stackTraceText;
    private final BaseEvent event;

    private MicroTimingMessage(class_5321<class_1937> dimensionType, class_2338 pos, class_1767 color, BaseEvent event, TickStage stage, String stageDetail, TickStageExtraBase stageExtra, class_2554 stackTraceText) {
        this.dimensionType = dimensionType;
        this.pos = pos.method_10062();
        this.color = color;
        this.event = event;
        this.stage = stage;
        this.stageDetail = stageDetail;
        this.stageExtra = stageExtra;
        this.stackTraceText = stackTraceText;
    }

    public MicroTimingMessage(MicroTimingLogger logger, class_5321<class_1937> dimensionType, class_2338 pos, class_1767 color, BaseEvent event) {
        this(dimensionType, pos, color, event, logger.getTickStage(), logger.getTickStageDetail(), logger.getTickStageExtra(), StackTracePrinter.create().ignore(MicroTimingLoggerManager.class).deobfuscate().toSymbolText());
    }

    public MessageType getMessageType() {
        return MessageType.fromEventType(this.event.getEventType());
    }

    public BaseEvent getEvent() {
        return this.event;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MicroTimingMessage)) {
            return false;
        }
        MicroTimingMessage message = (MicroTimingMessage)o;
        return Objects.equals(this.dimensionType, message.dimensionType) && Objects.equals(this.pos, message.pos) && this.color == message.color && this.stage == message.stage && Objects.equals(this.stageDetail, message.stageDetail) && Objects.equals(this.stageExtra, message.stageExtra) && Objects.equals(this.event, message.event);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.dimensionType, this.pos, this.color, this.stage, this.stageDetail, this.stageExtra, this.event});
    }

    private class_2554 getHashTagText() {
        String text = MicroTimingUtil.getColorStyle(this.color) + " # ";
        class_2554 ret = this.pos != null ? Messenger.c((Object[])new Object[]{text, "?" + TextUtil.getTeleportCommand((class_2382)this.pos, this.dimensionType), String.format("^w %s", TextUtil.getCoordinateString((class_2382)this.pos))}) : Messenger.c((Object[])new Object[]{text});
        return ret;
    }

    private class_2554 getStageText() {
        ArrayList stageText = Lists.newArrayList();
        stageText.add("y  " + this.stage.tr());
        if (this.stageDetail != null) {
            stageText.add("y ." + MicroTimingLoggerManager.tr("stage_detail." + this.stageDetail, this.stageDetail));
        }
        ArrayList hoverTextList = Lists.newArrayList();
        hoverTextList.add(this.stageExtra != null ? Messenger.c((Object[])new Object[]{this.stageExtra.toText(), "w \n"}) : Messenger.s((String)""));
        hoverTextList.add(String.format("w %s: ", MicroTimingLoggerManager.tr("Dimension")));
        hoverTextList.add(this.stage.isInsideWorld() ? TextUtil.getDimensionNameText(this.dimensionType) : "w N/A");
        return Messenger.c((Object[])new Object[]{"g  @", TextUtil.getFancyText(null, Messenger.c((Object[])stageText.toArray(new Object[0])), Messenger.c((Object[])hoverTextList.toArray(new Object[0])), this.stageExtra != null ? this.stageExtra.getClickEvent() : null)});
    }

    public static class_2554 getIndentationText(int indentation) {
        return Messenger.s((String)INDENTATIONS.get(Integer.min(indentation, 10)));
    }

    public class_2554 toText(int indentation, boolean showStage) {
        ArrayList line = Lists.newArrayList();
        if (indentation > 0) {
            line.add(MicroTimingMessage.getIndentationText(indentation));
        }
        line.add(this.getHashTagText());
        line.add(this.event.toText());
        if (this.event.getEventType() != EventType.ACTION_END && showStage) {
            line.add(this.getStageText());
        }
        line.add("w  ");
        line.add(this.stackTraceText);
        return Messenger.c((Object[])line.toArray(new Object[0]));
    }

    public void mergeQuiteMessage(MicroTimingMessage quiteMessage) {
        if (quiteMessage != null) {
            this.event.mergeQuitEvent(quiteMessage.event);
        }
    }

    static {
        String indent = "";
        for (int i = 0; i <= 10; ++i) {
            INDENTATIONS.add(indent);
            for (int j = 0; j < 2; ++j) {
                indent = indent + ' ';
            }
        }
    }
}

