/*
 * Decompiled with CFR 0.152.
 */
package carpettisaddition.logging.loggers.microtiming.utils;

import carpet.utils.Messenger;
import carpet.utils.WoolTool;
import carpettisaddition.CarpetTISAdditionSettings;
import carpettisaddition.logging.loggers.microtiming.MicroTimingLoggerManager;
import carpettisaddition.utils.TextUtil;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_124;
import net.minecraft.class_1767;
import net.minecraft.class_1937;
import net.minecraft.class_2231;
import net.minecraft.class_2241;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2269;
import net.minecraft.class_2312;
import net.minecraft.class_2318;
import net.minecraft.class_2337;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2401;
import net.minecraft.class_2426;
import net.minecraft.class_2457;
import net.minecraft.class_2458;
import net.minecraft.class_2459;
import net.minecraft.class_2537;
import net.minecraft.class_2554;
import net.minecraft.class_2561;
import net.minecraft.class_2665;
import net.minecraft.class_2667;
import net.minecraft.class_2680;
import net.minecraft.class_2738;
import net.minecraft.class_2741;
import net.minecraft.class_2769;

public class MicroTimingUtil {
    public static final class_2350[] DIRECTION_VALUES = class_2350.values();
    private static final Map<class_1767, String> COLOR_STYLE = Maps.newHashMap();

    public static String getColorStyle(class_1767 color) {
        return COLOR_STYLE.getOrDefault(color, "w");
    }

    public static class_2554 getColoredValue(Object value) {
        class_2554 text = Messenger.s((String)value.toString());
        class_124 color = null;
        if (Boolean.TRUE.equals(value)) {
            color = class_124.field_1060;
        } else if (Boolean.FALSE.equals(value)) {
            color = class_124.field_1061;
        }
        if (value instanceof Number) {
            color = class_124.field_1065;
        }
        if (color != null) {
            TextUtil.attachFormatting(text, color);
        }
        return text;
    }

    public static class_2554 getSuccessText(boolean value, boolean showReturnValue, class_2554 hoverExtra) {
        class_2554 hintText;
        class_2554 class_25542 = hintText = value ? Messenger.c((Object[])new Object[]{"e " + MicroTimingLoggerManager.tr("Successful")}) : Messenger.c((Object[])new Object[]{"r " + MicroTimingLoggerManager.tr("Failed")});
        if (hoverExtra != null) {
            hintText.method_10852((class_2561)Messenger.c((Object[])new Object[]{"w \n", hoverExtra}));
        }
        if (showReturnValue) {
            hintText.method_10852((class_2561)Messenger.c((Object[])new Object[]{String.format("w \n%s: ", MicroTimingLoggerManager.tr("Return value")), MicroTimingUtil.getColoredValue(value)}));
        }
        return value ? TextUtil.getFancyText("e", Messenger.s((String)"\u221a"), hintText, null) : TextUtil.getFancyText("r", Messenger.s((String)"\u00d7"), hintText, null);
    }

    public static class_2554 getSuccessText(boolean bool, boolean showReturnValue) {
        return MicroTimingUtil.getSuccessText(bool, showReturnValue, null);
    }

    private static boolean isPositionAvailable(class_1937 world, class_2338 pos) {
        return world.method_8398().method_20529(pos);
    }

    public static Optional<class_1767> getWoolColor(class_1937 world, class_2338 pos) {
        class_2338 woolPos;
        if (!MicroTimingLoggerManager.isLoggerActivated() || !MicroTimingUtil.isPositionAvailable(world, pos)) {
            return Optional.empty();
        }
        class_2680 state = world.method_8320(pos);
        class_2248 block = state.method_26204();
        if (block instanceof class_2426 || block instanceof class_2337 || block instanceof class_2665 || block instanceof class_2667) {
            woolPos = pos.method_10093(((class_2350)state.method_11654((class_2769)class_2741.field_12525)).method_10153());
        } else if (block instanceof class_2269 || block instanceof class_2401) {
            class_2350 facing = state.method_11654((class_2769)class_2741.field_12555) == class_2738.field_12475 ? class_2350.field_11036 : (state.method_11654((class_2769)class_2741.field_12555) == class_2738.field_12473 ? class_2350.field_11033 : (class_2350)state.method_11654((class_2769)class_2741.field_12481));
            woolPos = pos.method_10093(facing.method_10153());
        } else if (block instanceof class_2458 || block instanceof class_2537) {
            woolPos = pos.method_10093(((class_2350)state.method_11654((class_2769)class_2741.field_12481)).method_10153());
        } else if (block instanceof class_2241 || block instanceof class_2312 || block instanceof class_2459 || block instanceof class_2457 || block instanceof class_2231) {
            woolPos = pos.method_10074();
        } else {
            return Optional.empty();
        }
        return Optional.ofNullable(WoolTool.getWoolColorAtPosition((class_1937)world, (class_2338)woolPos));
    }

    public static Optional<class_1767> getEndRodWoolColor(class_1937 world, class_2338 pos) {
        if (!MicroTimingLoggerManager.isLoggerActivated() || !MicroTimingUtil.isPositionAvailable(world, pos)) {
            return Optional.empty();
        }
        for (class_2350 facing : DIRECTION_VALUES) {
            class_2338 woolPos;
            class_1767 color;
            class_2338 blockEndRodPos = pos.method_10093(facing);
            class_2680 iBlockState = world.method_8320(blockEndRodPos);
            if (iBlockState.method_26204() != class_2246.field_10455 || ((class_2350)iBlockState.method_11654((class_2769)class_2318.field_10927)).method_10153() != facing || (color = WoolTool.getWoolColorAtPosition((class_1937)world, (class_2338)(woolPos = blockEndRodPos.method_10093(facing)))) == null) continue;
            return Optional.of(color);
        }
        return Optional.empty();
    }

    public static Optional<class_1767> getWoolOrEndRodWoolColor(class_1937 world, class_2338 pos) {
        Optional<class_1767> optionalDyeColor = MicroTimingUtil.getWoolColor(world, pos);
        if (!optionalDyeColor.isPresent()) {
            optionalDyeColor = MicroTimingUtil.getEndRodWoolColor(world, pos);
        }
        if (!optionalDyeColor.isPresent()) {
            boolean useBackup;
            switch (CarpetTISAdditionSettings.microTimingTarget) {
                case IN_RANGE: {
                    useBackup = world.method_8604((double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5, 32.0, player -> true) != null;
                    break;
                }
                case ALL: {
                    useBackup = true;
                    break;
                }
                default: {
                    useBackup = false;
                }
            }
            if (useBackup) {
                optionalDyeColor = Optional.of(class_1767.field_7967);
            }
        }
        return optionalDyeColor;
    }

    public static String getFormattedDirectionString(class_2350 direction) {
        String name = direction.toString();
        String translatedName = MicroTimingLoggerManager.tr("direction." + name, name);
        char sign = direction.method_10171().method_10181() > 0 ? (char)'+' : '-';
        return String.format("%s (%c%s)", translatedName, Character.valueOf(sign), direction.method_10166());
    }

    static {
        COLOR_STYLE.put(class_1767.field_7952, "w");
        COLOR_STYLE.put(class_1767.field_7946, "d");
        COLOR_STYLE.put(class_1767.field_7958, "m");
        COLOR_STYLE.put(class_1767.field_7951, "c");
        COLOR_STYLE.put(class_1767.field_7947, "y");
        COLOR_STYLE.put(class_1767.field_7961, "l");
        COLOR_STYLE.put(class_1767.field_7954, "r");
        COLOR_STYLE.put(class_1767.field_7944, "f");
        COLOR_STYLE.put(class_1767.field_7967, "g");
        COLOR_STYLE.put(class_1767.field_7955, "q");
        COLOR_STYLE.put(class_1767.field_7945, "p");
        COLOR_STYLE.put(class_1767.field_7966, "v");
        COLOR_STYLE.put(class_1767.field_7957, "n");
        COLOR_STYLE.put(class_1767.field_7942, "e");
        COLOR_STYLE.put(class_1767.field_7964, "r");
        COLOR_STYLE.put(class_1767.field_7963, "k");
    }
}

