/*
 * Decompiled with CFR 0.152.
 */
package carpettisaddition.logging.loggers.raid;

import carpet.logging.LoggerRegistry;
import carpet.utils.Messenger;
import carpet.utils.Translations;
import carpettisaddition.logging.ExtensionLoggerRegistry;
import carpettisaddition.logging.loggers.AbstractLogger;
import carpettisaddition.utils.TextUtil;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2554;
import net.minecraft.class_3765;
import net.minecraft.class_5321;

public class RaidLogger
extends AbstractLogger {
    private static final RaidLogger instance = new RaidLogger();

    public RaidLogger() {
        super("raid");
    }

    public static RaidLogger getInstance() {
        return instance;
    }

    public void onRaidCreated(class_3765 raid) {
        if (!ExtensionLoggerRegistry.__raid) {
            return;
        }
        LoggerRegistry.getLogger((String)"raid").log(() -> new class_2554[]{Messenger.c((Object[])new Object[]{String.format("w %s", String.format(this.tr("created", "Raid created with id %d"), raid.method_16494())), "g  @ ", TextUtil.getCoordinateText("w", (class_2382)raid.method_16495(), (class_5321<class_1937>)raid.method_16831().method_27983())})});
    }

    public void onRaidInvalidated(class_3765 raid, InvalidateReason reason) {
        if (!ExtensionLoggerRegistry.__raid) {
            return;
        }
        LoggerRegistry.getLogger((String)"raid").log(() -> new class_2554[]{Messenger.c((Object[])new Object[]{String.format("w %s", String.format(this.tr("invalidated", "Raid (id: %d) invalidated, reason: %s"), raid.method_16494(), reason.tr()))})});
    }

    public void onBadOmenLevelIncreased(class_3765 raid, int badOmenLevel) {
        if (!ExtensionLoggerRegistry.__raid) {
            return;
        }
        LoggerRegistry.getLogger((String)"raid").log(() -> new class_2554[]{Messenger.c((Object[])new Object[]{String.format("w %s", String.format(this.tr("bad_omen_level_increased", "Raid (id: %d) increased its bad omen level to %d"), raid.method_16494(), badOmenLevel))})});
    }

    public void onCenterMoved(class_3765 raid, class_2338 pos) {
        if (!ExtensionLoggerRegistry.__raid) {
            return;
        }
        LoggerRegistry.getLogger((String)"raid").log(() -> new class_2554[]{Messenger.c((Object[])new Object[]{String.format("w %s", String.format(this.tr("center_moved", "Raid (id: %d) moves its center to"), raid.method_16494())), "w  ", TextUtil.getCoordinateText("w", (class_2382)pos, (class_5321<class_1937>)raid.method_16831().method_27983())})});
    }

    public static enum InvalidateReason {
        DIFFICULTY_PEACEFUL,
        GAMERULE_DISABLE,
        POI_REMOVED_BEFORE_SPAWN,
        TIME_OUT,
        RAIDER_CANNOT_SPAWN,
        RAID_VICTORY,
        RAID_DEFEAT;


        public String getName() {
            return this.name().toLowerCase();
        }

        public String tr() {
            return Translations.tr((String)("raid_invalidate_reason." + this.getName()), (String)this.getName().replace("_", " "));
        }
    }
}

