/*
 * Decompiled with CFR 0.152.
 */
package carpettisaddition.logging.loggers.ticket;

import carpet.logging.LoggerRegistry;
import carpet.utils.Messenger;
import carpettisaddition.logging.ExtensionLoggerRegistry;
import carpettisaddition.logging.loggers.AbstractLogger;
import carpettisaddition.utils.stacktrace.StackTracePrinter;
import java.util.Arrays;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_2554;
import net.minecraft.class_3218;
import net.minecraft.class_3228;

public class TicketLogger
extends AbstractLogger {
    private static final TicketLogger INSTANCE = new TicketLogger();

    public TicketLogger() {
        super("ticket");
    }

    public static TicketLogger getInstance() {
        return INSTANCE;
    }

    private String getAddedActionText() {
        return "l " + this.tr(" added");
    }

    private String getRemovedActionText() {
        return "r " + this.tr(" removed");
    }

    private String formatSize(int range) {
        range = Math.max(range, 0);
        int length = range * 2 - 1;
        return String.format("%d * %d", length, length);
    }

    private void onManipulateTicket(class_3218 world, long position, class_3228<?> chunkTicket, String actionText) {
        LoggerRegistry.getLogger((String)"ticket").log(option -> {
            if (Arrays.asList(option.split("[,. ]")).contains(chunkTicket.method_14281().toString())) {
                class_1923 pos = new class_1923(position);
                class_2338 centerPos = pos.method_8323().method_10069(8, 0, 8);
                long expiryTicks = chunkTicket.method_14281().method_20629();
                int level = chunkTicket.method_14283();
                String dimensionName = world.method_27983().method_29177().toString();
                return new class_2554[]{Messenger.c((Object[])new Object[]{String.format("g [%s] ", world.method_8510()), String.format(String.format("^w %s", this.tr("time_detail", "World: %s\nGameTime: %d")), dimensionName, world.method_8510()), String.format("w %s", this.tr("Ticket ")), String.format("d %s", chunkTicket.method_14281()), String.format(String.format("^w %s", this.tr("ticket_detail", "Level = %d\nDuration = %s\nEntity processing chunks: %s\nLazy processing chunks: %s\nBorder chunks: %s")), chunkTicket.method_14283(), expiryTicks > 0L ? expiryTicks + " gt" : this.tr("Permanent"), this.formatSize(32 - level), this.formatSize(33 - level), this.formatSize(34 - level)), actionText, String.format("g %s", this.tr(" at")), String.format("w  [%d, %d]", pos.field_9181, pos.field_9180), String.format(String.format("^w %s", this.tr("teleport_hint", "Click to teleport to chunk [%d, %d]")), pos.field_9181, pos.field_9180), String.format("?/execute in %s run tp %d ~ %d", dimensionName, centerPos.method_10263(), centerPos.method_10260()), "w  ", StackTracePrinter.create().ignore(TicketLogger.class).deobfuscate().toSymbolText()})};
            }
            return null;
        });
    }

    public static void onAddTicket(class_3218 world, long position, class_3228<?> chunkTicket) {
        if (ExtensionLoggerRegistry.__ticket) {
            INSTANCE.onManipulateTicket(world, position, chunkTicket, INSTANCE.getAddedActionText());
        }
    }

    public static void onRemoveTicket(class_3218 world, long position, class_3228<?> chunkTicket) {
        if (ExtensionLoggerRegistry.__ticket) {
            INSTANCE.onManipulateTicket(world, position, chunkTicket, INSTANCE.getRemovedActionText());
        }
    }
}

