/*
 * Decompiled with CFR 0.152.
 */
package carpettisaddition.mixins.command.lifetime;

import carpettisaddition.commands.lifetime.LifeTimeTracker;
import carpettisaddition.commands.lifetime.interfaces.IEntity;
import carpettisaddition.commands.lifetime.interfaces.IServerWorld;
import carpettisaddition.commands.lifetime.removal.RemovalReason;
import carpettisaddition.commands.lifetime.spawning.SpawningReason;
import carpettisaddition.commands.lifetime.utils.LifeTimeTrackerUtil;
import carpettisaddition.utils.GameUtil;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_1297.class})
public abstract class EntityMixin
implements IEntity {
    @Shadow
    public class_1937 field_6002;
    private long spawnTime;
    private boolean doLifeTimeTracking;
    private boolean recordedSpawning;
    private boolean recordedRemoval;
    private class_243 spawningPos;
    private class_243 removalPos;

    @Shadow
    public abstract class_243 method_19538();

    @Shadow
    public abstract class_1299<?> method_5864();

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    private void onConstructLifeTimeTracker(CallbackInfo ci) {
        this.doLifeTimeTracking = false;
        this.recordedSpawning = false;
        this.recordedRemoval = false;
        if (this.field_6002 instanceof class_3218) {
            this.spawnTime = ((IServerWorld)this.field_6002).getLifeTimeWorldTracker().getSpawnStageCounter();
            this.doLifeTimeTracking = LifeTimeTracker.isActivated() && LifeTimeTrackerUtil.isTrackedEntity((class_1297)this);
        }
    }

    @Override
    public long getLifeTime() {
        return ((IServerWorld)this.field_6002).getLifeTimeWorldTracker().getSpawnStageCounter() - this.spawnTime;
    }

    @Override
    public class_243 getSpawningPosition() {
        return this.spawningPos;
    }

    @Override
    public class_243 getRemovalPosition() {
        return this.removalPos;
    }

    @Override
    public void recordSpawning(SpawningReason reason) {
        if (this.doLifeTimeTracking && !this.recordedSpawning) {
            if ((class_1297)this instanceof class_1308 && !GameUtil.countsTowardsMobcap((class_1297)this)) {
                return;
            }
            this.recordedSpawning = true;
            this.spawningPos = this.method_19538();
            ((IServerWorld)this.field_6002).getLifeTimeWorldTracker().onEntitySpawn((class_1297)this, reason);
        }
    }

    @Override
    public void recordRemoval(RemovalReason reason) {
        if (this.doLifeTimeTracking && this.recordedSpawning && this.spawningPos != null && !this.recordedRemoval) {
            this.recordedRemoval = true;
            this.removalPos = this.method_19538();
            ((IServerWorld)this.field_6002).getLifeTimeWorldTracker().onEntityRemove((class_1297)this, reason);
        }
    }
}

