/*
 * Decompiled with CFR 0.152.
 */
package carpettisaddition.mixins.logger.damage;

import carpettisaddition.logging.loggers.damage.DamageLogger;
import carpettisaddition.logging.loggers.damage.interfaces.ILivingEntity;
import carpettisaddition.logging.loggers.damage.modifyreasons.ArmorModifyReason;
import carpettisaddition.logging.loggers.damage.modifyreasons.EnchantmentModifyReason;
import carpettisaddition.logging.loggers.damage.modifyreasons.ModifyReason;
import carpettisaddition.logging.loggers.damage.modifyreasons.StatusEffectModifyReason;
import java.util.Optional;
import net.minecraft.class_1282;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1890;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Slice;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1309.class})
public abstract class LivingEntityMixin
implements ILivingEntity {
    @Shadow
    protected float field_6253;
    private DamageLogger damageLogger;

    @Shadow
    public abstract class_1293 method_6112(class_1291 var1);

    @Shadow
    public abstract Iterable<class_1799> method_5661();

    @Override
    public Optional<DamageLogger> getDamageLogger() {
        return Optional.ofNullable(this.damageLogger);
    }

    @Override
    public void setDamageLogger(DamageLogger damageLogger) {
        this.damageLogger = damageLogger;
    }

    @Inject(method={"damage"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/LivingEntity;isSleeping()Z")})
    void onDamageStarted(class_1282 source, float amount, CallbackInfoReturnable<Boolean> cir) {
        DamageLogger.create((class_1309)this, source, amount);
    }

    @Inject(method={"damage"}, at={@At(value="CONSTANT", args={"floatValue=0.75F"})})
    void onHelmetReducedAnvilDamage(class_1282 source, float amount, CallbackInfoReturnable<Boolean> cir) {
        this.getDamageLogger().ifPresent(damageLogger -> damageLogger.modifyDamage(amount * 0.75f, ModifyReason.HELMET));
    }

    @Inject(method={"damage"}, slice={@Slice(from=@At(value="INVOKE", target="Lnet/minecraft/entity/LivingEntity;damageShield(F)V"))}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/damage/DamageSource;isProjectile()Z", ordinal=0)})
    void onShieldReducedDamage(class_1282 source, float amount, CallbackInfoReturnable<Boolean> cir) {
        this.getDamageLogger().ifPresent(damageLogger -> damageLogger.modifyDamage(amount, ModifyReason.SHIELD));
    }

    @Inject(method={"damage"}, at={@At(value="FIELD", target="Lnet/minecraft/entity/LivingEntity;lastDamageTaken:F", ordinal=0)})
    void onRecentHintReducedDamage(class_1282 source, float amount, CallbackInfoReturnable<Boolean> cir) {
        this.getDamageLogger().ifPresent(damageLogger -> damageLogger.modifyDamage(Math.max(amount - this.field_6253, 0.0f), ModifyReason.RECENTLY_HIT));
    }

    @Inject(method={"applyArmorToDamage"}, at={@At(value="RETURN")})
    void onArmorReducedDamage(class_1282 source, float amount, CallbackInfoReturnable<Float> cir) {
        this.getDamageLogger().ifPresent(damageLogger -> damageLogger.modifyDamage(amount, new ArmorModifyReason((class_1309)this)));
    }

    @Inject(method={"applyEnchantmentsToDamage"}, at={@At(value="INVOKE_ASSIGN", target="Ljava/lang/Math;max(FF)F")})
    void onResistanceReducedDamage(class_1282 source, float amount, CallbackInfoReturnable<Float> cir) {
        this.getDamageLogger().ifPresent(damageLogger -> damageLogger.modifyDamage(amount, new StatusEffectModifyReason(class_1294.field_5907, this.method_6112(class_1294.field_5907).method_5578())));
    }

    @Inject(method={"applyEnchantmentsToDamage"}, at={@At(value="INVOKE_ASSIGN", target="Lnet/minecraft/entity/DamageUtil;getInflictedDamage(FF)F")})
    void onEnchantmentReducedDamage(class_1282 source, float amount, CallbackInfoReturnable<Float> cir) {
        this.getDamageLogger().ifPresent(damageLogger -> {
            int epf = class_1890.method_8219(this.method_5661(), (class_1282)source);
            damageLogger.modifyDamage(amount, new EnchantmentModifyReason(epf));
        });
    }
}

