/*
 * Decompiled with CFR 0.152.
 */
package carpettisaddition.mixins.logger.microtiming.events;

import carpettisaddition.logging.loggers.microtiming.MicroTimingLoggerManager;
import carpettisaddition.logging.loggers.microtiming.enums.EventType;
import carpettisaddition.logging.loggers.microtiming.events.ExecuteBlockEventEvent;
import it.unimi.dsi.fastutil.objects.ObjectLinkedOpenHashSet;
import net.minecraft.class_1919;
import net.minecraft.class_1937;
import net.minecraft.class_1954;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={class_3218.class})
public abstract class ServerWorldMixin {
    private final ThreadLocal<Boolean> thisTileTickEventExecuted = ThreadLocal.withInitial(() -> false);
    @Shadow
    @Final
    private ObjectLinkedOpenHashSet<class_1919> field_13950;
    private int oldBlockActionQueueSize;

    @Inject(method={"tickBlock"}, at={@At(value="HEAD")})
    private void beforeExecuteTileTickEvent(class_1954<class_2248> event, CallbackInfo ci) {
        this.thisTileTickEventExecuted.set(false);
    }

    @Inject(method={"tickBlock"}, at={@At(value="INVOKE", target="Lnet/minecraft/block/BlockState;scheduledTick(Lnet/minecraft/server/world/ServerWorld;Lnet/minecraft/util/math/BlockPos;Ljava/util/Random;)V")})
    private void preExecuteTileTickEvent(class_1954<class_2248> event, CallbackInfo ci) {
        MicroTimingLoggerManager.onExecuteTileTickEvent((class_1937)((class_3218)this), event, EventType.ACTION_START);
        this.thisTileTickEventExecuted.set(true);
    }

    @Inject(method={"tickBlock"}, at={@At(value="RETURN")})
    private void afterExecuteTileTickEvent(class_1954<class_2248> event, CallbackInfo ci) {
        if (this.thisTileTickEventExecuted.get().booleanValue()) {
            MicroTimingLoggerManager.onExecuteTileTickEvent((class_1937)((class_3218)this), event, EventType.ACTION_END);
        }
    }

    @Inject(method={"addSyncedBlockEvent"}, at={@At(value="HEAD")})
    private void startScheduleBlockEvent(class_2338 pos, class_2248 block, int type, int data, CallbackInfo ci) {
        this.oldBlockActionQueueSize = this.field_13950.size();
    }

    @Inject(method={"addSyncedBlockEvent"}, at={@At(value="RETURN")})
    private void endScheduleBlockEvent(class_2338 pos, class_2248 block, int type, int data, CallbackInfo ci) {
        MicroTimingLoggerManager.onScheduleBlockEvent((class_1937)((class_3218)this), new class_1919(pos, block, type, data), this.field_13950.size() > this.oldBlockActionQueueSize);
    }

    @Inject(method={"processBlockEvent"}, at={@At(value="HEAD", shift=At.Shift.AFTER)})
    private void beforeBlockEventExecuted(class_1919 blockAction, CallbackInfoReturnable<Boolean> cir) {
        MicroTimingLoggerManager.onExecuteBlockEvent((class_1937)((class_3218)this), blockAction, null, null, EventType.ACTION_START);
    }

    @Inject(method={"processBlockEvent"}, at={@At(value="RETURN")}, locals=LocalCapture.CAPTURE_FAILHARD)
    private void afterBlockEventExecuted(class_1919 blockAction, CallbackInfoReturnable<Boolean> cir, class_2680 blockState) {
        ExecuteBlockEventEvent.FailInfo failInfo = new ExecuteBlockEventEvent.FailInfo(blockState.method_26204() != blockAction.method_8309() ? ExecuteBlockEventEvent.FailReason.BLOCK_CHANGED : ExecuteBlockEventEvent.FailReason.EVENT_FAIL, blockState.method_26204());
        MicroTimingLoggerManager.onExecuteBlockEvent((class_1937)((class_3218)this), blockAction, (Boolean)cir.getReturnValue(), failInfo, EventType.ACTION_END);
    }
}

