/*
 * Decompiled with CFR 0.152.
 */
package carpettisaddition.mixins.logger.raid;

import carpettisaddition.commands.raid.RaidTracker;
import carpettisaddition.logging.loggers.raid.IRaid;
import carpettisaddition.logging.loggers.raid.RaidLogger;
import net.minecraft.class_1657;
import net.minecraft.class_2338;
import net.minecraft.class_3765;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Slice;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_3765.class})
public abstract class RaidMixin
implements IRaid {
    @Shadow
    private int field_16623;
    private int previousBadOmenLevel;

    @Shadow
    public abstract boolean method_20023();

    @Inject(method={"<init>(ILnet/minecraft/server/world/ServerWorld;Lnet/minecraft/util/math/BlockPos;)V"}, at={@At(value="RETURN")})
    private void onConstruct(CallbackInfo ci) {
        RaidLogger.getInstance().onRaidCreated((class_3765)this);
    }

    @Override
    public void onRaidInvalidated(RaidLogger.InvalidateReason reason) {
        RaidLogger.getInstance().onRaidInvalidated((class_3765)this, reason);
        RaidTracker.getInstance().trackRaidInvalidated(reason);
    }

    @Inject(method={"start"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/player/PlayerEntity;getStatusEffect(Lnet/minecraft/entity/effect/StatusEffect;)Lnet/minecraft/entity/effect/StatusEffectInstance;")})
    private void onStartBeforeCalculated(class_1657 player, CallbackInfo ci) {
        this.previousBadOmenLevel = this.field_16623;
    }

    @Inject(method={"start"}, at={@At(value="INVOKE_ASSIGN", shift=At.Shift.AFTER, target="Lnet/minecraft/util/math/MathHelper;clamp(III)I")})
    private void onStarted(class_1657 player, CallbackInfo ci) {
        if (this.field_16623 > 1 && this.field_16623 > this.previousBadOmenLevel) {
            RaidLogger.getInstance().onBadOmenLevelIncreased((class_3765)this, this.field_16623);
        }
    }

    @Inject(method={"tick"}, slice={@Slice(from=@At(value="INVOKE", target="Lnet/minecraft/world/WorldAccess;getDifficulty()Lnet/minecraft/world/Difficulty;"))}, at={@At(value="INVOKE", target="Lnet/minecraft/village/raid/Raid;invalidate()V", ordinal=0)})
    private void onInvalidatedByDifficulty(CallbackInfo ci) {
        this.onRaidInvalidated(RaidLogger.InvalidateReason.DIFFICULTY_PEACEFUL);
    }

    @Inject(method={"tick"}, slice={@Slice(from=@At(value="INVOKE", target="Lnet/minecraft/server/world/ServerWorld;isNearOccupiedPointOfInterest(Lnet/minecraft/util/math/BlockPos;)Z"))}, at={@At(value="INVOKE", target="Lnet/minecraft/village/raid/Raid;invalidate()V", ordinal=0)})
    private void onInvalidatedByPOINotFound(CallbackInfo ci) {
        this.onRaidInvalidated(RaidLogger.InvalidateReason.POI_REMOVED_BEFORE_SPAWN);
    }

    @Inject(method={"tick"}, slice={@Slice(from=@At(value="CONSTANT", args={"longValue=48000"}, ordinal=0))}, at={@At(value="INVOKE", target="Lnet/minecraft/village/raid/Raid;invalidate()V", ordinal=0)})
    private void onInvalidatedByTimeOut(CallbackInfo ci) {
        this.onRaidInvalidated(RaidLogger.InvalidateReason.TIME_OUT);
    }

    @Inject(method={"tick"}, slice={@Slice(from=@At(value="INVOKE", target="Lnet/minecraft/village/raid/Raid;playRaidHorn(Lnet/minecraft/util/math/BlockPos;)V"))}, at={@At(value="INVOKE", target="Lnet/minecraft/village/raid/Raid;invalidate()V", ordinal=0)})
    private void onInvalidatedByRaiderCannotSpawn(CallbackInfo ci) {
        this.onRaidInvalidated(RaidLogger.InvalidateReason.RAIDER_CANNOT_SPAWN);
    }

    @Inject(method={"tick"}, slice={@Slice(from=@At(value="CONSTANT", args={"intValue=600"}))}, at={@At(value="INVOKE", target="Lnet/minecraft/village/raid/Raid;invalidate()V", ordinal=0)})
    private void onInvalidatedByFinished(CallbackInfo ci) {
        if (this.method_20023()) {
            this.onRaidInvalidated(RaidLogger.InvalidateReason.RAID_VICTORY);
        } else {
            this.onRaidInvalidated(RaidLogger.InvalidateReason.RAID_DEFEAT);
        }
    }

    @Inject(method={"setCenter"}, at={@At(value="HEAD")})
    void onCenterMoved(class_2338 blockPos, CallbackInfo ci) {
        RaidLogger.getInstance().onCenterMoved((class_3765)this, blockPos);
    }
}

