/*
 * Decompiled with CFR 0.152.
 */
package carpettisaddition.mixins.rule.optimizedFastEntityMovement;

import carpettisaddition.CarpetTISAdditionSettings;
import java.util.stream.Stream;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_3538;
import net.minecraft.class_3726;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;

@Mixin(value={class_1297.class})
public abstract class EntityMixin {
    private static final ThreadLocal<Boolean> optimizedFastEntityMovementEnable = ThreadLocal.withInitial(() -> false);
    private static final ThreadLocal<class_1937> currentCollidingWorld = new ThreadLocal();
    private static final ThreadLocal<class_1297> currentCollidingEntity = new ThreadLocal();
    private static final double OPTIMIZE_THRESHOLD = 4.0;

    @Redirect(method={"adjustMovementForCollisions(Lnet/minecraft/entity/Entity;Lnet/minecraft/util/math/Vec3d;Lnet/minecraft/util/math/Box;Lnet/minecraft/world/World;Lnet/minecraft/block/ShapeContext;Lnet/minecraft/util/collection/ReusableStream;)Lnet/minecraft/util/math/Vec3d;"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/World;getBlockCollisions(Lnet/minecraft/entity/Entity;Lnet/minecraft/util/math/Box;)Ljava/util/stream/Stream;"))
    private static Stream<class_265> dontUseThatLargeBlockCollisions(class_1937 world, class_1297 entity, class_238 box, class_1297 entityParam, class_243 movement, class_238 entityBoundingBox, class_1937 worldParam, class_3726 context, class_3538<class_265> collisions) {
        optimizedFastEntityMovementEnable.set(CarpetTISAdditionSettings.optimizedFastEntityMovement && movement.method_1027() >= 16.0);
        if (optimizedFastEntityMovementEnable.get().booleanValue()) {
            currentCollidingEntity.set(entity);
            currentCollidingWorld.set(world);
            return Stream.empty();
        }
        return world.method_20812(entity, box);
    }

    @Redirect(method={"adjustMovementForCollisions(Lnet/minecraft/util/math/Vec3d;Lnet/minecraft/util/math/Box;Lnet/minecraft/util/collection/ReusableStream;)Lnet/minecraft/util/math/Vec3d;"}, at=@At(value="INVOKE", target="Lnet/minecraft/util/shape/VoxelShapes;calculateMaxOffset(Lnet/minecraft/util/math/Direction$Axis;Lnet/minecraft/util/math/Box;Ljava/util/stream/Stream;D)D"), require=4)
    private static double useAxisOnlyBlockCollisions(class_2350.class_2351 axis, class_238 box, Stream<class_265> shapes, double maxDist, class_243 movement, class_238 entityBoundingBox, class_3538<class_265> collisions) {
        if (optimizedFastEntityMovementEnable.get().booleanValue()) {
            class_243 axisOnlyMovement = null;
            switch (axis) {
                case field_11048: {
                    axisOnlyMovement = new class_243(movement.method_10216(), 0.0, 0.0);
                    break;
                }
                case field_11052: {
                    axisOnlyMovement = new class_243(0.0, movement.method_10214(), 0.0);
                    break;
                }
                case field_11051: {
                    axisOnlyMovement = new class_243(0.0, 0.0, movement.method_10215());
                }
            }
            Stream blockCollisions = currentCollidingWorld.get().method_20812(currentCollidingEntity.get(), entityBoundingBox.method_18804(axisOnlyMovement));
            shapes = Stream.concat(blockCollisions, collisions.method_15418());
        }
        return class_259.method_1085((class_2350.class_2351)axis, (class_238)box, shapes, (double)maxDist);
    }
}

