/*
 * Decompiled with CFR 0.152.
 */
package carpettisaddition.translations;

import carpet.utils.Translations;
import carpettisaddition.translations.Translatable;

public class Translator
implements Translatable {
    private final String type;
    private final String name;
    private final String translationPath;

    public Translator(String type, String name) {
        this.type = type;
        this.name = name;
        this.translationPath = this.generateTranslationPath();
    }

    public String getTranslationPath() {
        return this.translationPath;
    }

    private String generateTranslationPath() {
        String path = "";
        if (this.type != null) {
            path = path + this.type + ".";
        }
        if (this.name != null) {
            path = path + this.name + ".";
        }
        if (path.endsWith(".")) {
            path = path.substring(0, path.length() - 1);
        }
        return path;
    }

    public Translator(String prefix) {
        this(null, prefix);
    }

    private String getPath(String key, boolean autoFormat) {
        String path = this.getTranslationPath();
        if (!path.isEmpty()) {
            path = path + ".";
        }
        key = key.toLowerCase();
        if (autoFormat) {
            key = key.trim().replace(" ", "_");
        }
        return path + key;
    }

    @Override
    public String tr(String key, String text, boolean autoFormat) {
        return Translations.tr((String)this.getPath(key, autoFormat), (String)text);
    }

    @Override
    public String tr(String key, String text) {
        return this.tr(key, text, false);
    }

    @Override
    public String tr(String key) {
        return Translations.tr((String)this.getPath(key, true), (String)key);
    }
}

