/*
 * Decompiled with CFR 0.152.
 */
package carpettisaddition.utils;

import carpet.utils.Messenger;
import carpet.utils.Translations;
import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1320;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2554;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2588;
import net.minecraft.class_5321;

public class TextUtil {
    private static final Map<class_5321<class_1937>, class_2554> DIMENSION_NAME = Maps.newHashMap();

    public static class_2554 attachHoverEvent(class_2554 text, class_2568 hoverEvent) {
        text.method_10862(text.method_10866().method_10949(hoverEvent));
        return text;
    }

    public static class_2554 attachHoverText(class_2554 text, class_2554 hoverText) {
        return TextUtil.attachHoverEvent(text, new class_2568(class_2568.class_5247.field_24342, (Object)hoverText));
    }

    public static class_2554 attachClickEvent(class_2554 text, class_2558 clickEvent) {
        text.method_10862(text.method_10866().method_10958(clickEvent));
        return text;
    }

    public static class_2554 attachFormatting(class_2554 text, class_124 ... formattings) {
        text.method_27695(formattings);
        return text;
    }

    public static class_2554 copyText(class_2554 text) {
        return (class_2554)text.method_27661();
    }

    private static String getTeleportHint() {
        return Translations.tr((String)"util.teleport_hint", (String)"Click to teleport to");
    }

    public static String getTeleportCommand(class_243 pos, class_5321<class_1937> dim) {
        return String.format("/execute in %s run tp %s %s %s", dim.method_29177(), pos.method_10216(), pos.method_10214(), pos.method_10215());
    }

    public static String getTeleportCommand(class_243 pos) {
        return String.format("/tp %s %s %s", pos.method_10216(), pos.method_10214(), pos.method_10215());
    }

    public static String getTeleportCommand(class_2382 pos) {
        return String.format("/tp %d %d %d", pos.method_10263(), pos.method_10264(), pos.method_10260());
    }

    public static String getTeleportCommand(class_2382 pos, class_5321<class_1937> dim) {
        return String.format("/execute in %s run tp %d %d %d", dim.method_29177(), pos.method_10263(), pos.method_10264(), pos.method_10260());
    }

    public static String getTeleportCommandPlayer(class_1657 player) {
        String name = player.method_7334().getName();
        return String.format("/tp %s", name);
    }

    public static String getTeleportCommand(class_1297 entity) {
        if (entity instanceof class_1657) {
            return TextUtil.getTeleportCommandPlayer((class_1657)entity);
        }
        String uuid = entity.method_5667().toString();
        return String.format("/tp %s", uuid);
    }

    public static class_2554 getFancyText(String style, class_2554 displayText, class_2554 hoverText, class_2558 clickEvent) {
        class_2554 text = TextUtil.copyText(displayText);
        if (style != null) {
            text.method_10862(Messenger.parseStyle((String)style));
        }
        if (hoverText != null) {
            TextUtil.attachHoverText(text, hoverText);
        }
        if (clickEvent != null) {
            TextUtil.attachClickEvent(text, clickEvent);
        }
        return text;
    }

    private static class_2554 __getCoordinateText(String style, class_5321<class_1937> dim, String posText, String command) {
        class_2554 hoverText = Messenger.s((String)"");
        hoverText.method_27693(String.format("%s %s\n", TextUtil.getTeleportHint(), posText));
        hoverText.method_27693(Translations.tr((String)"util.teleport_hint.dimension", (String)"Dimension"));
        hoverText.method_27693(": ");
        hoverText.method_10852((class_2561)TextUtil.getDimensionNameText(dim));
        return TextUtil.getFancyText(style, Messenger.s((String)posText), hoverText, new class_2558(class_2558.class_2559.field_11745, command));
    }

    public static String getCoordinateString(class_243 pos) {
        return String.format("[%.1f, %.1f, %.1f]", pos.method_10216(), pos.method_10214(), pos.method_10215());
    }

    public static String getCoordinateString(class_2382 pos) {
        return String.format("[%d, %d, %d]", pos.method_10263(), pos.method_10264(), pos.method_10260());
    }

    public static class_2554 getCoordinateText(String style, class_243 pos, class_5321<class_1937> dim) {
        return TextUtil.__getCoordinateText(style, dim, TextUtil.getCoordinateString(pos), TextUtil.getTeleportCommand(pos, dim));
    }

    public static class_2554 getCoordinateText(String style, class_2382 pos, class_5321<class_1937> dim) {
        return TextUtil.__getCoordinateText(style, dim, TextUtil.getCoordinateString(pos), TextUtil.getTeleportCommand(pos, dim));
    }

    public static class_2554 getEntityText(String style, class_1297 entity) {
        class_2554 entityName = TextUtil.copyText((class_2554)entity.method_5864().method_5897());
        class_2554 hoverText = Messenger.c((Object[])new Object[]{"w " + TextUtil.getTeleportHint(), TextUtil.getSpaceText(), entityName});
        return TextUtil.getFancyText(style, entityName, hoverText, new class_2558(class_2558.class_2559.field_11745, TextUtil.getTeleportCommand(entity)));
    }

    public static class_2554 getAttributeText(class_1320 attribute) {
        return new class_2588(attribute.method_26830());
    }

    public static class_2554 getDimensionNameText(class_5321<class_1937> dim) {
        return TextUtil.copyText(DIMENSION_NAME.getOrDefault(dim, Messenger.s((String)dim.toString())));
    }

    public static class_2588 getTranslatedName(String key, class_124 color, Object ... args) {
        class_2588 text = new class_2588(key, args);
        if (color != null) {
            TextUtil.attachFormatting((class_2554)text, color);
        }
        return text;
    }

    public static class_2588 getTranslatedName(String key, Object ... args) {
        return TextUtil.getTranslatedName(key, null, args);
    }

    public static class_2554 getBlockName(class_2248 block) {
        return TextUtil.attachFormatting((class_2554)new class_2588(block.method_9539()), class_124.field_1068);
    }

    public static String getSpace() {
        return Translations.tr((String)"language_tool.space", (String)" ");
    }

    public static class_2554 getSpaceText() {
        return Messenger.s((String)TextUtil.getSpace());
    }

    static {
        DIMENSION_NAME.put((class_5321<class_1937>)class_1937.field_25179, (class_2554)new class_2588("createWorld.customize.preset.overworld"));
        DIMENSION_NAME.put((class_5321<class_1937>)class_1937.field_25180, (class_2554)new class_2588("advancements.nether.root.title"));
        DIMENSION_NAME.put((class_5321<class_1937>)class_1937.field_25181, (class_2554)new class_2588("advancements.end.root.title"));
    }
}

