/*
 * Decompiled with CFR 0.152.
 */
package carpettisaddition.utils.stacktrace;

import carpet.utils.Messenger;
import carpettisaddition.translations.Translator;
import carpettisaddition.utils.TextUtil;
import carpettisaddition.utils.stacktrace.StackTraceDeobfuscator;
import com.google.common.base.Joiner;
import java.util.Arrays;
import java.util.List;
import net.minecraft.class_2554;

public class StackTracePrinter {
    private static final int DEFAULT_MAX_STACK_TRACE_SIZE = 64;
    private static final Translator translator = StackTraceDeobfuscator.translator;
    private StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
    private int maxStackTraceSize = 64;
    private String ignorePackagePath;

    private StackTracePrinter() {
    }

    public static StackTracePrinter create() {
        return new StackTracePrinter();
    }

    public StackTracePrinter limit(int maxStackTraceSize) {
        this.maxStackTraceSize = maxStackTraceSize;
        return this;
    }

    public StackTracePrinter ignore(String ignorePackagePath) {
        this.ignorePackagePath = ignorePackagePath;
        return this;
    }

    public StackTracePrinter ignore(Class<?> ignoreClass) {
        return this.ignore(ignoreClass.getPackage().getName());
    }

    public StackTracePrinter deobfuscate() {
        this.stackTrace = StackTraceDeobfuscator.deobfuscateStackTrace(this.stackTrace, this.ignorePackagePath);
        return this;
    }

    public StackTraceElement[] toStackTraceElements() {
        return this.stackTrace;
    }

    @Deprecated
    public class_2554 toBaseText() {
        List<StackTraceElement> list = Arrays.asList(this.stackTrace).subList(0, Integer.min(this.stackTrace.length, this.maxStackTraceSize));
        int restLineCount = this.stackTrace.length - this.maxStackTraceSize;
        String text = Joiner.on((String)"\n").join(list);
        if (restLineCount > 0) {
            text = text + "\n... " + String.format(translator.tr("n_more_lines", "%d more lines"), restLineCount);
        }
        return Messenger.s((String)text);
    }

    public class_2554 toSymbolText() {
        return TextUtil.getFancyText("f", Messenger.s((String)"$"), this.toBaseText(), null);
    }
}

