/*
 * Decompiled with CFR 0.152.
 */
package io.github.gunpowder.modelhandlers;

import io.github.gunpowder.api.GunpowderDatabase;
import io.github.gunpowder.api.module.teleport.dataholders.StoredHome;
import io.github.gunpowder.modelhandlers.HomeHandler;
import io.github.gunpowder.models.HomeTable;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.exposed.sql.Column;
import org.jetbrains.exposed.sql.Expression;
import org.jetbrains.exposed.sql.ExpressionWithColumnType;
import org.jetbrains.exposed.sql.Op;
import org.jetbrains.exposed.sql.OpKt;
import org.jetbrains.exposed.sql.QueriesKt;
import org.jetbrains.exposed.sql.SqlExpressionBuilder;
import org.jetbrains.exposed.sql.Table;
import org.jetbrains.exposed.sql.Transaction;
import org.jetbrains.exposed.sql.statements.InsertStatement;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010$\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u0006H\u0016J\u001a\u0010\u0017\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u0006H\u0016J\u001c\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u001a2\u0006\u0010\u0018\u001a\u00020\u0005H\u0016J\b\u0010\u001b\u001a\u00020\u001cH\u0002J\u0010\u0010\u001d\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0007H\u0016R&\u0010\u0003\u001a\u001a\u0012\u0004\u0012\u00020\u0005\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\b\u001a\u00020\t8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\n\u0010\u000bR\u001b\u0010\u000e\u001a\u00020\u000f8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0012\u0010\r\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001e"}, d2={"Lio/github/gunpowder/modelhandlers/HomeHandler;", "Lio/github/gunpowder/api/module/teleport/modelhandlers/HomeHandler;", "()V", "cache", "", "Ljava/util/UUID;", "", "Lio/github/gunpowder/api/module/teleport/dataholders/StoredHome;", "db", "Lio/github/gunpowder/api/GunpowderDatabase;", "getDb", "()Lio/github/gunpowder/api/GunpowderDatabase;", "db$delegate", "Lkotlin/Lazy;", "homeLimit", "", "getHomeLimit", "()I", "homeLimit$delegate", "delHome", "", "player", "home", "getHome", "user", "getHomes", "", "loadEntries", "", "newHome", "gunpowder-teleport"})
public final class HomeHandler
implements io.github.gunpowder.api.module.teleport.modelhandlers.HomeHandler {
    private static final Lazy db$delegate;
    private static final Map<UUID, Map<String, StoredHome>> cache;
    @NotNull
    private static final Lazy homeLimit$delegate;
    @NotNull
    public static final HomeHandler INSTANCE;

    private final GunpowderDatabase getDb() {
        Lazy lazy = db$delegate;
        HomeHandler homeHandler = this;
        Object var3_3 = null;
        boolean bl = false;
        return (GunpowderDatabase)lazy.getValue();
    }

    public final int getHomeLimit() {
        Lazy lazy = homeLimit$delegate;
        HomeHandler homeHandler = this;
        Object var3_3 = null;
        boolean bl = false;
        return ((Number)lazy.getValue()).intValue();
    }

    private final void loadEntries() {
        Map temp2;
        Map map = temp2 = (Map)this.getDb().transaction((Function1)loadEntries.temp.1.INSTANCE).get();
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"temp");
        cache.putAll(map);
    }

    @Nullable
    public StoredHome getHome(@NotNull UUID user, @NotNull String home) {
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        Intrinsics.checkNotNullParameter((Object)home, (String)"home");
        Map<String, StoredHome> map = cache.get(user);
        return map != null ? map.get(home) : null;
    }

    @NotNull
    public Map<String, StoredHome> getHomes(@NotNull UUID user) {
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        Map map = cache.get(user);
        if (map == null) {
            boolean bl = false;
            map = MapsKt.emptyMap();
        }
        return map;
    }

    public boolean newHome(@NotNull StoredHome home) {
        Map c;
        Intrinsics.checkNotNullParameter((Object)home, (String)"home");
        Map map = cache.get(home.getUser());
        if (map == null) {
            boolean bl = false;
            map = c = (Map)new LinkedHashMap();
        }
        if (c.size() >= this.getHomeLimit()) {
            if (c.get(home.getName()) == null) {
                return false;
            }
            this.delHome(home.getUser(), home.getName());
        }
        c.put(home.getName(), home);
        cache.put(home.getUser(), c);
        this.getDb().transaction((Function1)new Function1<Transaction, InsertStatement<Number>>(home){
            final /* synthetic */ StoredHome $home;

            @NotNull
            public final InsertStatement<Number> invoke(@NotNull Transaction $this$transaction) {
                Intrinsics.checkNotNullParameter((Object)$this$transaction, (String)"$receiver");
                return QueriesKt.insert((Table)HomeTable.INSTANCE, (Function2)((Function2)new Function2<HomeTable, InsertStatement<Number>, Unit>(this){
                    final /* synthetic */ newHome.1 this$0;

                    public final void invoke(@NotNull HomeTable $this$insert, @NotNull InsertStatement<Number> it) {
                        Intrinsics.checkNotNullParameter((Object)((Object)$this$insert), (String)"$receiver");
                        Intrinsics.checkNotNullParameter(it, (String)"it");
                        it.set($this$insert.getOwner(), (Object)this.this$0.$home.getUser());
                        it.set($this$insert.getName(), (Object)this.this$0.$home.getName());
                        it.set($this$insert.getX(), (Object)this.this$0.$home.getLocation().method_10263());
                        it.set($this$insert.getY(), (Object)this.this$0.$home.getLocation().method_10264());
                        it.set($this$insert.getZ(), (Object)this.this$0.$home.getLocation().method_10260());
                        Column<String> column = $this$insert.getDimension();
                        String string = this.this$0.$home.getDimension().toString();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"home.dimension.toString()");
                        it.set(column, (Object)string);
                    }
                    {
                        this.this$0 = var1_1;
                        super(2);
                    }
                }));
            }
            {
                this.$home = storedHome;
                super(1);
            }
        });
        return true;
    }

    public boolean delHome(@NotNull UUID player, @NotNull String home) {
        Map c;
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)home, (String)"home");
        Map map = cache.get(player);
        if (map == null) {
            boolean bl = false;
            map = c = (Map)new LinkedHashMap();
        }
        if (c.get(home) == null) {
            return false;
        }
        c.remove(home);
        cache.put(player, c);
        this.getDb().transaction((Function1)new Function1<Transaction, Integer>(player, home){
            final /* synthetic */ UUID $player;
            final /* synthetic */ String $home;

            public final int invoke(@NotNull Transaction $this$transaction) {
                Intrinsics.checkNotNullParameter((Object)$this$transaction, (String)"$receiver");
                return QueriesKt.deleteWhere$default((Table)HomeTable.INSTANCE, null, null, (Function1)((Function1)new Function1<SqlExpressionBuilder, Op<Boolean>>(this){
                    final /* synthetic */ delHome.1 this$0;

                    @NotNull
                    public final Op<Boolean> invoke(@NotNull SqlExpressionBuilder $this$deleteWhere) {
                        Intrinsics.checkNotNullParameter((Object)$this$deleteWhere, (String)"$receiver");
                        return OpKt.and((Expression)((Expression)$this$deleteWhere.eq((ExpressionWithColumnType)HomeTable.INSTANCE.getOwner(), (Object)this.this$0.$player)), (Expression)((Expression)$this$deleteWhere.eq((ExpressionWithColumnType)HomeTable.INSTANCE.getName(), (Object)this.this$0.$home)));
                    }
                    {
                        this.this$0 = var1_1;
                        super(1);
                    }
                }), (int)3, null);
            }
            {
                this.$player = uUID;
                this.$home = string;
                super(1);
            }
        });
        return true;
    }

    private HomeHandler() {
    }

    static {
        HomeHandler homeHandler;
        INSTANCE = homeHandler = new HomeHandler();
        db$delegate = LazyKt.lazy((Function0)db.2.INSTANCE);
        boolean bl = false;
        cache = new LinkedHashMap();
        homeLimit$delegate = LazyKt.lazy((Function0)homeLimit.2.INSTANCE);
        homeHandler.loadEntries();
    }
}

